from django.conf.urls import patterns, include, url
from django.contrib.auth.decorators import permission_required
import vouchers.views
import vouchers.models

urlpatterns = patterns('',
    url(r'list/', vouchers.views.show_requests, name='list_requests', ),
    url(r'reimbursement/', 'vouchers.views.select_request_basics', name='request_reimbursement', ),
    (r'submit/(?P<term>[\d\w-]+)/(?P<committee>[\d\w-]+)/(?P<recipient_type>mit|other)/', 'vouchers.views.submit_request', ),
    url(r'review/(?P<object_id>\d+)/', 'vouchers.views.review_request', name='review_request', ),
    url(r'^generate/vouchers.tex$', 'vouchers.views.generate_vouchers', name='generate_vouchers', ),
    url(r'^generate/rfps.csv$', 'vouchers.views.generate_rfp_specs', name='generate_rfp_specs', ),
)
